Ext.data.JsonP.sol_common_StringUtils({"tagname":"class","name":"sol.common.StringUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.StringUtils.js","href":"lib_sol.common.StringUtils.html#sol-common-StringUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloall":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"contains","tagname":"method","owner":"sol.common.StringUtils","id":"method-contains","meta":{}},{"name":"endsWith","tagname":"method","owner":"sol.common.StringUtils","id":"method-endsWith","meta":{}},{"name":"format","tagname":"method","owner":"sol.common.StringUtils","id":"method-format","meta":{}},{"name":"getTrailingNumber","tagname":"method","owner":"sol.common.StringUtils","id":"method-getTrailingNumber","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isBlank","tagname":"method","owner":"sol.common.StringUtils","id":"method-isBlank","meta":{}},{"name":"isEmpty","tagname":"method","owner":"sol.common.StringUtils","id":"method-isEmpty","meta":{}},{"name":"isNumeric","tagname":"method","owner":"sol.common.StringUtils","id":"method-isNumeric","meta":{}},{"name":"padLeft","tagname":"method","owner":"sol.common.StringUtils","id":"method-padLeft","meta":{}},{"name":"padRight","tagname":"method","owner":"sol.common.StringUtils","id":"method-padRight","meta":{}},{"name":"parseIniString","tagname":"method","owner":"sol.common.StringUtils","id":"method-parseIniString","meta":{}},{"name":"removeQuotes","tagname":"method","owner":"sol.common.StringUtils","id":"method-removeQuotes","meta":{}},{"name":"removeTrailingNumber","tagname":"method","owner":"sol.common.StringUtils","id":"method-removeTrailingNumber","meta":{}},{"name":"replaceAll","tagname":"method","owner":"sol.common.StringUtils","id":"method-replaceAll","meta":{}},{"name":"replaceLineBreaks","tagname":"method","owner":"sol.common.StringUtils","id":"method-replaceLineBreaks","meta":{}},{"name":"splitLines","tagname":"method","owner":"sol.common.StringUtils","id":"method-splitLines","meta":{}},{"name":"startsWith","tagname":"method","owner":"sol.common.StringUtils","id":"method-startsWith","meta":{}},{"name":"truncate","tagname":"method","owner":"sol.common.StringUtils","id":"method-truncate","meta":{"protected":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.StringUtils","short_doc":"This class contains convinience methods for working with strings. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.StringUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils' target='_blank'>lib_sol.common.StringUtils.js</a></div></pre><div class='doc-contents'><p>This class contains convinience methods for working with strings.</p>\n\n<p>Works transparently with Java and JavaScript Strings</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-contains' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-contains' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-contains' class='name expandable'>contains</a>( <span class='pre'>str, pattern</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a string contains another string ...</div><div class='long'><p>Checks, if a string contains another string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>pattern</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-endsWith' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-endsWith' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-endsWith' class='name expandable'>endsWith</a>( <span class='pre'>str, pattern</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a string ends with another string ...</div><div class='long'><p>Checks, if a string ends with another string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>pattern</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-format' class='name expandable'>format</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a formatted string. ...</div><div class='long'><p>Returns a formatted string.\nThe first parameter contains the String which should be formatted.\nThis parameter is followed by an arbitary number uf strings, which will be used to replace the placefolders.</p>\n\n<h1>Examples</h1>\n\n<pre><code><a href=\"#!/api/sol.common.StringUtils-method-format\" rel=\"sol.common.StringUtils-method-format\" class=\"docClass\">sol.common.StringUtils.format</a>(\"Hello {0}!\", \"world\");\n\n<a href=\"#!/api/sol.common.StringUtils-method-format\" rel=\"sol.common.StringUtils-method-format\" class=\"docClass\">sol.common.StringUtils.format</a>(\"An error occurred writing object {0} to database. Exception was: {1}\", objId, ex);\n\n<a href=\"#!/api/sol.common.StringUtils-method-format\" rel=\"sol.common.StringUtils-method-format\" class=\"docClass\">sol.common.StringUtils.format</a>(\"Value of {0} updated: {1} -&gt; {2}\", key, oldValue, newValue);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>String which should be formated, containing placeholders</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTrailingNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-getTrailingNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-getTrailingNumber' class='name expandable'>getTrailingNumber</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the trailing number string ...</div><div class='long'><p>Returns the trailing number string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Number string</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isBlank' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-isBlank' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-isBlank' class='name expandable'>isBlank</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a string is not defined/null, empty or contains only whitespaces ...</div><div class='long'><p>Checks, if a string is not defined/null, empty or contains only whitespaces</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-isEmpty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-isEmpty' class='name expandable'>isEmpty</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a string is not defined/null or empty ...</div><div class='long'><p>Checks, if a string is not defined/null or empty</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isNumeric' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-isNumeric' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-isNumeric' class='name expandable'>isNumeric</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a string has a numeric value ...</div><div class='long'><p>Checks, if a string has a numeric value</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-padLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-padLeft' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-padLeft' class='name expandable'>padLeft</a>( <span class='pre'>str, length, [padString]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Pads a string at the left side ...</div><div class='long'><p>Pads a string at the left side</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String|Number<div class='sub-desc'><p>Input string</p>\n</div></li><li><span class='pre'>length</span> : Number<div class='sub-desc'><p>Destination length of the string</p>\n</div></li><li><span class='pre'>padString</span> : String (optional)<div class='sub-desc'><p>Padding string</p>\n<p>Defaults to: <code>&quot;0&quot;</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Padded string</p>\n</div></li></ul></div></div></div><div id='method-padRight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-padRight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-padRight' class='name expandable'>padRight</a>( <span class='pre'>str, length, [padString]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Pads a string at the right side ...</div><div class='long'><p>Pads a string at the right side</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String|Number<div class='sub-desc'><p>Input string</p>\n</div></li><li><span class='pre'>length</span> : Number<div class='sub-desc'><p>Destination length of the string</p>\n</div></li><li><span class='pre'>padString</span> : String (optional)<div class='sub-desc'><p>Padding string</p>\n<p>Defaults to: <code>&quot;0&quot;</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Padded string</p>\n</div></li></ul></div></div></div><div id='method-parseIniString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-parseIniString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-parseIniString' class='name expandable'>parseIniString</a>( <span class='pre'>iniString</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Parses an INI string ...</div><div class='long'><p>Parses an INI string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iniString</span> : String<div class='sub-desc'><p>INI file content</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Object</p>\n</div></li></ul></div></div></div><div id='method-removeQuotes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-removeQuotes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-removeQuotes' class='name expandable'>removeQuotes</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Remove quotes ...</div><div class='long'><p>Remove quotes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>String without quotes</p>\n</div></li></ul></div></div></div><div id='method-removeTrailingNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-removeTrailingNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-removeTrailingNumber' class='name expandable'>removeTrailingNumber</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes the trailing number ...</div><div class='long'><p>Removes the trailing number</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Number string</p>\n</div></li></ul></div></div></div><div id='method-replaceAll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-replaceAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-replaceAll' class='name expandable'>replaceAll</a>( <span class='pre'>str, target, replacement</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Replaces every occurrence of a substring with another string ...</div><div class='long'><p>Replaces every occurrence of a substring with another string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li><li><span class='pre'>target</span> : String<div class='sub-desc'><p>String to replace</p>\n</div></li><li><span class='pre'>replacement</span> : String<div class='sub-desc'><p>Replacement string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Padded string</p>\n</div></li></ul></div></div></div><div id='method-replaceLineBreaks' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-replaceLineBreaks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-replaceLineBreaks' class='name expandable'>replaceLineBreaks</a>( <span class='pre'>str, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes line breaks ...</div><div class='long'><p>Removes line breaks</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>replaceString</span> : String<div class='sub-desc'><p>Replace string</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-splitLines' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-splitLines' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-splitLines' class='name expandable'>splitLines</a>( <span class='pre'>text</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Splits a string into lines ...</div><div class='long'><p>Splits a string into lines</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : String<div class='sub-desc'><p>Text</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>lines</p>\n</div></li></ul></div></div></div><div id='method-startsWith' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-startsWith' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-startsWith' class='name expandable'>startsWith</a>( <span class='pre'>str, pattern</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a string starts with another string ...</div><div class='long'><p>Checks, if a string starts with another string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>pattern</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-truncate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.StringUtils'>sol.common.StringUtils</span><br/><a href='source/lib_sol.common.StringUtils.html#sol-common-StringUtils-method-truncate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.StringUtils-method-truncate' class='name expandable'>truncate</a>( <span class='pre'>str, maxLength, options</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Truncates a string to the appropriate length\nmaxlength is the total length from the string to be shortened plus the l...</div><div class='long'><p>Truncates a string to the appropriate length\nmaxlength is the total length from the string to be shortened plus the length of the suffix.</p>\n\n<p>That means with the default suffix \"...\", the original str will be shorten earlier as expected.\nExample:\nFor the result: \"Hello...\" you have to call the truncate function in this way\n<a href=\"#!/api/sol.common.StringUtils-method-truncate\" rel=\"sol.common.StringUtils-method-truncate\" class=\"docClass\">sol.common.StringUtils.truncate</a>(\"Hello World\", 8)</p>\n\n<p>If you want to skip ellipsies at the end, you can call\n<code><a href=\"#!/api/sol.common.StringUtils-method-truncate\" rel=\"sol.common.StringUtils-method-truncate\" class=\"docClass\">sol.common.StringUtils.truncate</a>(\"Hello World\", 5, { suffix: \"\" })</code></p>\n\n<p>This result in the str <code>Hello</code> without any suffix. This is the same like substr(0, 5)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>the string to truncate</p>\n</div></li><li><span class='pre'>maxLength</span> : String|Number<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>suffix</span> : String<div class='sub-desc'><p>Appending to the truncate str.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>truncate string. If str is shorter than maxLength - suffix.length than the same str will be return</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});